/************************************************************************
 *									*
 *	Calc.app()							*
 *									*
 *	Calculator.h							*
 *									*
 * 	Copyright(C)1995,97 Masayuki Kobayashi				*
 *	E-mail:kobamasa@ogata.or.jp					*
 *									*
 ************************************************************************
 *	ver0.99								*
 * 	ver0.99.1	BUGFIX						*
 ************************************************************************/

#import <appkit/appkit.h>

#define	MAX_VALUE	99999999999999.0	/* 914 */
#define	MIN_VALUE	0.0000000000001		/* 013 */
#define	MAX_EFFC	14			/* ͭ */

#define	BASE_BIN	 2
#define	BASE_OCT	 8
#define	BASE_DEC	10
#define	BASE_HEX	16

#define	NOP		0

#define	PERIOD		20
#define	NO_PERIOD	20	/* 1礭Ф */
#define	SIGN		21
#define	NOT		30

#define	EQU		90
#define	OR		100		
#define	XOR		101
#define	AND		200
#define	PLUS		300
#define	MINUS		301
#define	MULTI		400
#define	DIVIS		401

#define	MPLUS		500
#define	MMINUS		501
#define	MRES		502


#define	OPERATIONKEY	0
#define	OTHERKEY	1
#define	DIRECTKEY	2

#define	MAXSTACKCOUNT	10

#define	INPUT		0
#define	ANSWER		1

@interface Calculator:Object
{
    id	display;
    id	key0;
    id	key1;
    id	key2;
    id	key3;
    id	key4;
    id	key5;
    id	key6;
    id	key7;
    id	key8;
    id	key9;
    id	keyA;
    id	keyB;
    id	keyBase;
    id	keyC;
    id	keyD;
    id	keyE;
    id	keyF;
    id	keyPeriod;
    id  keyPlus;
    id  keyMinus;
    id  keyMulti;
    id  keyDivis;
    id  keyEqu;
    id  keyNot;
    id  keyOr;
    id  keyXor;
    id  keyAnd;
    id  keyOrder;
    id  memoryFlag;
    id  kFlag;
    id  overFlag;
    id  underFlag;
    id  comma;
    id  distance;	/* ֳ */
    id  distanceTitle;
    id  issigned;
    id  infoPanel;
    id  helpPanel;

	double	numStack[MAXSTACKCOUNT];
	int	oprStack[MAXSTACKCOUNT];
	int	numSP;
	int	oprSP;
	int	base;		/* (2,8,10,16) */
	double	memory;
	int	pushKeyType;
	int	effc;		/* Ϥ줿ͤʸ */
	double	secondBase;
	int	smallnum;	/* 貿̤ޤϤ */
	int	kmode;
	double	knum;
	int	kopr;
	int	keep_issigned;
}

- appDidInit:sender;
- allClearKey:sender;
- baseKey:sender;
- clearKey:sender;
- digitKey:sender;
- textDidGetKeys:sender isEmpty:(BOOL)flag;
- memoryClearKey:sender;
- memoryKey:sender;
- operationKey:sender;
- displayForByteOrder:sender;
- displayForComma:sender;
- display:(int)mode;
- CalOperation:(int)code;
- (double)flowCheck:(double)value;
- (int)str2num;
- kClear;
- selectAll:sender;
- showInfo:sender;
- showHelp:sender;
- windowDidResize:sender;

@end
