/************************************************************************
 *									*
 *	Calc.app()							*
 *									*
 *	Calculator.m							*
 *									*
 * 	Copyright(C)1995,97 Masayuki Kobayashi				*
 *	E-mail:kobamasa@ogata.or.jp					*
 *									*
 ************************************************************************
 *	ver0.99								*
 * 	ver0.99.1	BUGFIX						*
 ************************************************************************/

#import "Calculator.h"

/************************************************************************
 *	դοѴ					*
 ************************************************************************/
static	char	*str_comma(coma,dis)
char	*coma;
int	dis;
{
	char	*buff;
	char	*b;
	char	*period;
	char	*p=coma;
	int	len;
	int	i;

	b=buff=NXCopyStringBuffer(coma);
	if((period=strchr(buff,'.'))==NULL){	
		len=strlen(buff);
	}else{
		len=period-buff;
	}
	if(*buff=='-'){
		len--;
		*p++=*b++;
	}
	while(len>0){
		i=(len%dis!=0 ? len%dis : dis)-1;
		for(;i>=0;i--,len--)	*p++=*b++;
		if(len>0)	*p++=',';
	}
	*p='\0';
	if(period!=NULL)	strcat(coma,period);
	free(buff);
	return(coma);
}

/************************************************************************
 *	դο򥳥ޤʤˤ				*
 ************************************************************************/
static	char	*str_comma_cut(coma)
char	*coma;
{
	char	*buff;
	char	*b;
	char	*p=coma;

	b=buff=NXCopyStringBuffer(coma);
	while(*b!='\0'){
		if(*b!=',')	*p++=*b;
		b++;
	}
	*p='\0';
	free(buff);
	return(coma);
}

unsigned long	convertByteOrder(v)
unsigned long	v;
{
	unsigned int	b1,b2,b3,b4;

	b1=(v>>24)&0xff;
	b2=(v>>16)&0xff;
	b3=(v>>8)&0xff;
	b4=(v)&0xff;
	return(b1+(b2<<8)+(b3<<16)+(b4<<24));
}

@implementation Calculator

/************************************************************************
 * 								*
 ************************************************************************/
- appDidInit:sender
{
	if([keyBase selectCellWithTag:BASE_DEC]==nil){
		NXLogError("keyBase(dec) Tag != %d",BASE_DEC);
		exit(1);
	}
	[self baseKey:self];
	[self allClearKey:self];
	[self memoryClearKey:self];
	[[display window] setFrameAutosaveName:"$$Calc"];	/*ǥեȥǡ١(.NeXT/.NeXTdefault.L)˵Ͽ */
	if([comma state]==0){
		[distance setEnabled:NO];
		[distanceTitle setTextGray:NX_DKGRAY];
	}else{
		[distance setEnabled:YES];
		[distanceTitle setTextGray:NX_BLACK];
	}
	[[display window] makeKeyAndOrderFront:self];
	[display selectText:self];
	return self;
}

/************************************************************************
 * 	ACܥν							*
 ************************************************************************/
- allClearKey:sender
{
	pushKeyType=OTHERKEY;
	numSP=0;
	oprSP=0;
	numStack[0]=0;
	oprStack[0]=NOP;
	secondBase=NO_PERIOD;
	effc=0;
	[overFlag setStringValue:""];
	[underFlag setStringValue:""];
	[self kClear];
	[self display:ANSWER];	
	smallnum=0;
    return self;
}

/************************************************************************
 * 	饸ܥν						*
 ************************************************************************/
- baseKey:sender
{
	[self str2num];
	base=[keyBase selectedTag];
	switch(base){
		case BASE_BIN:
				[[key2 setEnabled:NO] setBordered:NO];
				[[key3 setEnabled:NO] setBordered:NO];
				[[key4 setEnabled:NO] setBordered:NO];
				[[key5 setEnabled:NO] setBordered:NO];
				[[key6 setEnabled:NO] setBordered:NO];
				[[key7 setEnabled:NO] setBordered:NO];
				[[key8 setEnabled:NO] setBordered:NO];
				[[key9 setEnabled:NO] setBordered:NO];
				[[keyA setEnabled:NO] setBordered:NO];
				[[keyB setEnabled:NO] setBordered:NO];
				[[keyC setEnabled:NO] setBordered:NO];
				[[keyD setEnabled:NO] setBordered:NO];
				[[keyE setEnabled:NO] setBordered:NO];
				[[keyF setEnabled:NO] setBordered:NO];
				[[keyPeriod setEnabled:NO] setBordered:NO];
				[[keyNot setEnabled:YES] setBordered:YES];
				[[keyOr setEnabled:YES] setBordered:YES];
				[[keyXor setEnabled:YES] setBordered:YES];
				[[keyAnd setEnabled:YES] setBordered:YES];
				if([keyOrder isEnabled]!=YES){
					char	icon[MAXPATHLEN];
					char	altIcon[MAXPATHLEN];

					strcpy(icon,[keyOrder icon]);
					strcpy(altIcon,[keyOrder altIcon]);
					[keyOrder setIcon:altIcon];
					[keyOrder setAltIcon:icon];
				}
				[[keyOrder setEnabled:YES] setBordered:YES];
				[[issigned setEnabled:YES] setState:keep_issigned];
				break;
		case BASE_OCT:
				[[key2 setEnabled:YES] setBordered:YES];
				[[key3 setEnabled:YES] setBordered:YES];
				[[key4 setEnabled:YES] setBordered:YES];
				[[key5 setEnabled:YES] setBordered:YES];
				[[key6 setEnabled:YES] setBordered:YES];
				[[key7 setEnabled:YES] setBordered:YES];
				[[key8 setEnabled:NO] setBordered:NO];
				[[key9 setEnabled:NO] setBordered:NO];
				[[keyA setEnabled:NO] setBordered:NO];
				[[keyB setEnabled:NO] setBordered:NO];
				[[keyC setEnabled:NO] setBordered:NO];
				[[keyD setEnabled:NO] setBordered:NO];
				[[keyE setEnabled:NO] setBordered:NO];
				[[keyF setEnabled:NO] setBordered:NO];
				[[keyPeriod setEnabled:NO] setBordered:NO];
				[[keyNot setEnabled:YES] setBordered:YES];
				[[keyOr setEnabled:YES] setBordered:YES];
				[[keyXor setEnabled:YES] setBordered:YES];
				[[keyAnd setEnabled:YES] setBordered:YES];
				if([keyOrder isEnabled]!=YES){
					char	icon[MAXPATHLEN];
					char	altIcon[MAXPATHLEN];

					strcpy(icon,[keyOrder icon]);
					strcpy(altIcon,[keyOrder altIcon]);
					[keyOrder setIcon:altIcon];
					[keyOrder setAltIcon:icon];
				}
				[[keyOrder setEnabled:YES] setBordered:YES];
				[[issigned setEnabled:YES] setState:keep_issigned];
				break;
		case BASE_DEC:
				[[key2 setEnabled:YES] setBordered:YES];
				[[key3 setEnabled:YES] setBordered:YES];
				[[key4 setEnabled:YES] setBordered:YES];
				[[key5 setEnabled:YES] setBordered:YES];
				[[key6 setEnabled:YES] setBordered:YES];
				[[key7 setEnabled:YES] setBordered:YES];
				[[key8 setEnabled:YES] setBordered:YES];
				[[key9 setEnabled:YES] setBordered:YES];
				[[keyA setEnabled:NO] setBordered:NO];
				[[keyB setEnabled:NO] setBordered:NO];
				[[keyC setEnabled:NO] setBordered:NO];
				[[keyD setEnabled:NO] setBordered:NO];
				[[keyE setEnabled:NO] setBordered:NO];
				[[keyF setEnabled:NO] setBordered:NO];
				[[keyPeriod setEnabled:YES] setBordered:YES];
				[[keyNot setEnabled:NO] setBordered:NO];
				[[keyOr setEnabled:NO] setBordered:NO];
				[[keyXor setEnabled:NO] setBordered:NO];
				[[keyAnd setEnabled:NO] setBordered:NO];
				if([keyOrder isEnabled]!=NO){
					char	icon[MAXPATHLEN];
					char	altIcon[MAXPATHLEN];

					strcpy(icon,[keyOrder icon]);
					strcpy(altIcon,[keyOrder altIcon]);
					[keyOrder setIcon:altIcon];
					[keyOrder setAltIcon:icon];
				}
				[[keyOrder setEnabled:NO] setBordered:NO];
				keep_issigned=[issigned state];
				[[issigned setEnabled:NO] setState:1];
				break;
		case BASE_HEX:
				[[key2 setEnabled:YES] setBordered:YES];
				[[key3 setEnabled:YES] setBordered:YES];
				[[key4 setEnabled:YES] setBordered:YES];
				[[key5 setEnabled:YES] setBordered:YES];
				[[key6 setEnabled:YES] setBordered:YES];
				[[key7 setEnabled:YES] setBordered:YES];
				[[key8 setEnabled:YES] setBordered:YES];
				[[key9 setEnabled:YES] setBordered:YES];
				[[keyA setEnabled:YES] setBordered:YES];
				[[keyB setEnabled:YES] setBordered:YES];
				[[keyC setEnabled:YES] setBordered:YES];
				[[keyD setEnabled:YES] setBordered:YES];
				[[keyE setEnabled:YES] setBordered:YES];
				[[keyF setEnabled:YES] setBordered:YES];
				[[keyPeriod setEnabled:NO] setBordered:NO];
				[[keyNot setEnabled:YES] setBordered:YES];
				[[keyOr setEnabled:YES] setBordered:YES];
				[[keyXor setEnabled:YES] setBordered:YES];
				[[keyAnd setEnabled:YES] setBordered:YES];
				if([keyOrder isEnabled]!=YES){
					char	icon[MAXPATHLEN];
					char	altIcon[MAXPATHLEN];

					strcpy(icon,[keyOrder icon]);
					strcpy(altIcon,[keyOrder altIcon]);
					[keyOrder setIcon:altIcon];
					[keyOrder setAltIcon:icon];
				}
				[[keyOrder setEnabled:YES] setBordered:YES];
				[[issigned setEnabled:YES] setState:keep_issigned];
				break;
		default:
				NXLogError("illegal Value keyBase's Tag");
				exit(1);
				break;
	}
	[self display:ANSWER];
    return self;
}

/************************************************************************
 * 	CEܥν							*
 ************************************************************************/
- clearKey:sender
{
	numStack[numSP]=0;
	secondBase=NO_PERIOD;
	effc=0;
	[self display:ANSWER];	
	smallnum=0;
    return self;
}

/************************************************************************
 * 	͡AF.+/-ܥν					*
 *	̤ϥܥΥǹԤäƤ					*
 ************************************************************************/
- digitKey:sender
{
	int	code;

	code=[sender selectedTag];
	if(oprStack[oprSP]==EQU && code!=SIGN){
		numStack[numSP]=0;
		oprStack[oprSP]=NOP;
		secondBase=NO_PERIOD;
		effc=0;
		smallnum=0;
	}
	if(code>=0 && code<=15){
		if([keyBase selectedTag]==BASE_DEC && (numStack[numSP]!=0 || secondBase<=1 || code!=0))	effc++;
		if(effc<=MAX_EFFC){
			if(secondBase>1){
				if([keyBase selectedTag]==BASE_DEC){
					numStack[numSP]=numStack[numSP]*base+code;
				}else{
					unsigned long	ul;

					ul=numStack[numSP];
					ul=ul*base+code;
					numStack[numSP]=(long)ul;
				}
			}else{
				smallnum++;
				secondBase/=base;
				if(numStack[numSP]>=0){
					numStack[numSP]+=code*secondBase;
				}else{
					numStack[numSP]-=code*secondBase;
				}
			}
		}else{
			NXBeep();
		}
	}else if(code==PERIOD){
		if(smallnum==0){
			secondBase=1;
			oprStack[oprSP]=NOP;
			if(numStack[numSP]==0)	effc++;
		}
	}else if(code==SIGN){
		[self str2num];
		numStack[numSP]=-numStack[numSP];
		[self displayForComma:self];
		pushKeyType=OTHERKEY;
		return self;
	}else if(code==NOT){
		[self str2num];
		if([issigned state]){
			numStack[numSP]=(double)(~(long)numStack[numSP]);
		}else{
			numStack[numSP]=(double)((long)(~(unsigned long)numStack[numSP]));
		}
		[self displayForComma:self];
		pushKeyType=OTHERKEY;
		return self;
	}else{
		NXLogError("illegal Value digitKey's Tag");
		exit(1);
	}
	[self display:INPUT];
	pushKeyType=OTHERKEY;
    return self;
}

/************************************************************************
 * 	ƥȥեɤ˥Ϥ˸ƤФ			*
 ************************************************************************/
- textDidGetKeys:sender isEmpty:(BOOL)flag
{
	char	*buff,*p;
	int	code;

	buff=NXCopyStringBuffer([display stringValue]);
	p=buff+strlen(buff)-1;
	switch(*p){
		case '+': code=PLUS;
			  break;
		case '-': code=MINUS;
			  break;
		case '*': code=MULTI;
			  break;
		case '/': code=DIVIS;
			  break;
		case '\n':
		case '=': code=EQU;
			  break;
		default : code=-1;
	}
	if(code>=0){
		*p='\0';
		if(*buff!='\0'){
			[display setStringValue:buff];
			pushKeyType=DIRECTKEY;
		}else{
			//pushKeyType=OTHERKEY;
			int	keep;

			keep=numSP;
			if(numSP>0)	numSP--;
			[self display:ANSWER];
			numSP=keep;
		}
		[self CalOperation:code];
	}else{
		pushKeyType=DIRECTKEY;
	}
	free(buff);
	return self;
}

/************************************************************************
 * 	MCܥν							*
 ************************************************************************/
- memoryClearKey:sender
{
	[memoryFlag setStringValue:""];
	memory=0;
    return self;
}

/************************************************************************
 * 	꡼ܥν						*
 ************************************************************************/
- memoryKey:sender
{
	switch([sender selectedTag]){
		case MPLUS:
				if(kmode==NO)	[self CalOperation:EQU];
				memory+=numStack[numSP];
				memory=[self flowCheck:memory];
				break;
		case MMINUS:
				if(kmode==NO)	[self CalOperation:EQU];
				memory-=numStack[numSP];
				memory=[self flowCheck:memory];
				break;
		case MRES:
				numStack[numSP]=memory;
				[self display:ANSWER];
				oprStack[oprSP]=EQU;
				break;
		default:
				NXLogError("illegal Value memoryKey's Tag");
				exit(1);
				break;
	}
	if(memory>=MIN_VALUE || memory<=-MIN_VALUE){
		[memoryFlag setStringValue:"M"];
	}else{
		[self memoryClearKey:self];
	}
	pushKeyType=OTHERKEY;
    return self;
}

/************************************************************************
 * 	ܡݡߡܥν						*
 ************************************************************************/
- operationKey:sender
{
	[self CalOperation:[sender selectedTag]];
    return self;
}

/************************************************************************
 * 	ХȥѴɽ					*
 ************************************************************************/
- displayForByteOrder:sender
{
	int	keep;
	int	oprSP2;

	[self str2num];
	keep=numSP;
	oprSP2=oprSP;
	if(pushKeyType==OPERATIONKEY && numSP>0){
		numSP--;
		oprSP2--;
	}
	numStack[numSP]=(long)convertByteOrder((unsigned long)numStack[numSP]);
	if(oprStack[oprSP2]==EQU)	[self display:ANSWER];
	else				[self display:INPUT];
	numSP=keep;
	return self;
}

/************************************************************************
 * 	ˤοͤɽ				*
 ************************************************************************/
- displayForComma:sender
{
	int	keep;
	int	oprSP2;

	if([comma state]==0){
		[distance setEnabled:NO];
		[distanceTitle setTextGray:NX_DKGRAY];
	}else{
		[distance setEnabled:YES];
		[distanceTitle setTextGray:NX_BLACK];
	}
	[self str2num];
	keep=numSP;
	oprSP2=oprSP;
	if(pushKeyType==OPERATIONKEY && numSP>0){
		numSP--;
		oprSP2--;
	}
	if(oprStack[oprSP2]==EQU)	[self display:ANSWER];
	else				[self display:INPUT];
	numSP=keep;
	return self;
}

/************************************************************************
 * 	ͤɽ							*
 ************************************************************************/
- display:(int)mode
{
	char	buff[128];
	//BOOL	inter=NO;

	switch(base){
		case BASE_BIN:
				if([issigned state]){
					char	buff2[64];
					char	*p;
					long	num;
					int	sign;
					int	i;

					p=buff2+sizeof(buff2)-1;
					*p--='\0';
					if((num=numStack[numSP])>=0)	sign=NO;
					else				sign=YES;
					for(i=1;i<=31;i++){
						if(num%2==0)	*p--='0';
						else		*p--='1';
						num/=2;
					}
					if(sign==YES)	*p='-';
					else		*p=' ';
					strcpy(buff,p);
				}else{
					char	buff2[64];
					char	*p;
					unsigned long	num;
					int	i;

					p=buff2+sizeof(buff2)-1;
					*p--='\0';
					num=numStack[numSP];
					for(i=1;i<=32;i++){
						if(num%2==0)	*p--='0';
						else		*p--='1';
						num/=2;
					}
					p++;
					strcpy(buff,p);
				}
				break;
		case BASE_OCT:
				if([issigned state]){
					if(numStack[numSP]<0){
						sprintf(buff,"-%011o",~(unsigned long)numStack[numSP]+1);
						break;
					}
				}
				sprintf(buff,"%011o",(long)numStack[numSP]);
				break;
		case BASE_DEC:
			{
				char	buff2[64];
				char	*p=buff2,*l;
				int	small;
				int	size;

				if(mode==ANSWER){
					if(numStack[numSP]>=10){
						small=MAX_EFFC-1-log10(numStack[numSP]);
						if(small<0)	small=0;
					}else if(numStack[numSP]<=-10){
						small=MAX_EFFC-1-log10(-numStack[numSP]);
						if(small<0)	small=0;
					}else{
						small=MAX_EFFC-1;
					}
				}else			small=smallnum;
				sprintf(buff2,"%31.*f",small,numStack[numSP]);
				if(small==0)	strcat(buff2,".");
				while(*p==' ')	p++;
				if(mode==ANSWER){
					l=p+strlen(p)-1;
					while(*l=='0')	l--;
					*(l+1)='\0';
				}
				strcpy(buff,p);
				if(*buff!='-')	size=MAX_EFFC+1;
				else		size=MAX_EFFC+2;
				if(strlen(buff)>size){
					[overFlag setStringValue:"over"];
					//inter=YES;
				}
				break;
			}
		case BASE_HEX:
				if([issigned state]){
					if(numStack[numSP]<0){
						sprintf(buff,"-%08X",~(unsigned long)numStack[numSP]+1);
						break;
					}
				}
				sprintf(buff,"%08X",(long)numStack[numSP]);
				break;
	}
	if(strncmp(buff,"NaN",3)==0){
		strcpy(buff,"׻Ǥޤ");
	}else if(strncmp(buff+1,"Infinity",8)==0){
		strcpy(buff+1,"̵");
	}
	if([comma state]==1)	str_comma(buff,[distance selectedTag]);
	[display setStringValue:buff];
	[display selectText:nil];
	//if(inter){
	//	NXRunAlertPanel("顼","ɽƤ˴ؤ륨顼Ǥ׻ˤϻپ㤬ޤ󤬡ȯ륱Ԥ𤷤Ƥ",NULL,NULL,NULL);
	//}
	return self;
}

/************************************************************************
 * 	׻							*
 ************************************************************************/
- CalOperation:(int)code
{
	int	preOpr;

	if([self str2num]==NO)	return self;
	preOpr=oprStack[oprSP];
	if(pushKeyType==OPERATIONKEY){
		if(code==EQU && (oprStack[oprSP-1]==MULTI || oprStack[oprSP-1]==DIVIS)){
			numStack[numSP]=numStack[numSP-1];	/* ,* or /,=ν */
		}else if(oprSP>=1){
			numSP--;
			oprSP--;
			if(oprSP==0 && oprStack[0]==code){
				[kFlag setStringValue:"K"];	/* ,§黻,Ʊ黻ν */
				kmode=YES;
				knum=numStack[0];
				kopr=oprStack[0];
				oprStack[0]=EQU;
				return self;
			}
		}
		oprStack[oprSP]=code;
	}
	if(kmode==YES){
		if(oprSP==0 && code==EQU){
			oprStack[0]=kopr;
			numStack[1]=knum;
			numSP++;
			oprSP++;
		}else{
			if(preOpr==NOP){
				numStack[1]=numStack[0];			
				numStack[0]=knum;			
				oprStack[0]=kopr;
				oprStack[1]=code;
				numSP++;
				oprSP++;
			}
			[self kClear];
		}
	}
	if(oprStack[oprSP]==NOP || oprStack[oprSP]==EQU)	oprStack[oprSP]=code;
	if(oprSP>=1){
		int	operation=NO;

		while(oprSP>=1 && oprStack[oprSP-1]/10 >= oprStack[oprSP]/10){
			if([keyBase selectedTag]==BASE_DEC){
				switch(oprStack[oprSP-1]){
					case PLUS:	numStack[numSP-1]+=numStack[numSP];
							break;
					case MINUS:	numStack[numSP-1]-=numStack[numSP];
							break;
					case MULTI:	numStack[numSP-1]*=numStack[numSP];
							break;
					case DIVIS:	numStack[numSP-1]/=numStack[numSP];
							break;
				}
			}else if([issigned state]){
				long	a=numStack[numSP-1];
				long	b=numStack[numSP];

				switch(oprStack[oprSP-1]){
					case OR:	a|=b;
							break;
					case XOR:	a^=b;
							break;
					case AND:	a&=b;
							break;
					case PLUS:	a+=b;
							break;
					case MINUS:	a-=b;
							break;
					case MULTI:	a*=b;
							break;
					case DIVIS:	a/=b;
							break;
				}
				numStack[numSP-1]=a;
			}else{
				unsigned long	a=numStack[numSP-1];
				unsigned long	b=numStack[numSP];

				switch(oprStack[oprSP-1]){
					case OR:	a|=b;
							break;
					case XOR:	a^=b;
							break;
					case AND:	a&=b;
							break;
					case PLUS:	a+=b;
							break;
					case MINUS:	a-=b;
							break;
					case MULTI:	a*=b;
							break;
					case DIVIS:	a/=b;
							break;
				}
				numStack[numSP-1]=(long)a;
			}
			oprStack[oprSP-1]=oprStack[oprSP];
			numSP--;
			oprSP--;
			numStack[numSP]=[self flowCheck:numStack[numSP]];
			operation=YES;
		}	
		if(operation)	[self display:ANSWER];
	}
	if(oprStack[oprSP]!=EQU){
		numSP++;
		oprSP++;
		numStack[oprSP]=0;
		oprStack[oprSP]=NOP;
		secondBase=NO_PERIOD;
		effc=0;
	}else{
		[self display:ANSWER];
	}
	smallnum=0;
	pushKeyType=OPERATIONKEY;
    return self;
}

- (double)flowCheck:(double)value
{
	if(value<MIN_VALUE && value>-MIN_VALUE && value!=0){
		[underFlag setStringValue:"under"];
		value=0;
	}
	if(value>MAX_VALUE || value<-MAX_VALUE){
		[overFlag setStringValue:"over"];
	}
    return value;
}

/************************************************************************
 * 	ʸͤѴ						*
 ************************************************************************/
- (int)str2num
{
	if(pushKeyType==DIRECTKEY){
		char	*buff;
		char	*p;
		int	skip=NO;

		
		p=buff=NXCopyStringBuffer([display stringValue]);
		str_comma_cut(buff);

		pushKeyType=OTHERKEY;	
		numStack[numSP]=0;
		secondBase=NO_PERIOD;
		effc=0;
		smallnum=0;
		while(*p!='\0'){
			if(*p=='0')			[key0 performClick:nil];
			else if(*p=='1')		[key1 performClick:nil];
			else if(*p=='2' && base>2)	[key2 performClick:nil];
			else if(*p=='3' && base>3)	[key3 performClick:nil];
			else if(*p=='4' && base>4)	[key4 performClick:nil];
			else if(*p=='5' && base>5)	[key5 performClick:nil];
			else if(*p=='6' && base>6)	[key6 performClick:nil];
			else if(*p=='7' && base>7)	[key7 performClick:nil];
			else if(*p=='8' && base>8)	[key8 performClick:nil];
			else if(*p=='9' && base>9)	[key9 performClick:nil];
			else if((*p=='A' || *p=='a') && base>10)	[keyA performClick:nil];
			else if((*p=='B' || *p=='b') && base>11)	[keyB performClick:nil];
			else if((*p=='C' || *p=='c') && base>12)	[keyC performClick:nil];
			else if((*p=='D' || *p=='d') && base>13)	[keyD performClick:nil];
			else if((*p=='E' || *p=='e') && base>14)	[keyE performClick:nil];
			else if((*p=='F' || *p=='f') && base>15)	[keyF performClick:nil];
			else if(*p=='.' && base==10)	[keyPeriod performClick:nil];
			else if(*p=='+')		[keyPlus performClick:nil];
			else if(*p=='-')		[keyMinus performClick:nil];
			else if(*p=='*')		[keyMulti performClick:nil];
			else if(*p=='/')		[keyDivis performClick:nil];
			else if(*p=='\n' || *p=='=')	[keyEqu performClick:nil];
			else if(*p=='\t' || *p==' ');
			else{
				if(skip==NO){
					int	rc;

					rc=NXRunAlertPanel("","Ͱʳʸ(%c)ޤޤƤޤ","ٿͤ(CE)","ʸФ","Ͱʳ٤Ф",*p);
					switch(rc){
						case NX_ALERTDEFAULT:
							[self clearKey:nil];
							free(buff);
							return NO;
							break;
						case NX_ALERTALTERNATE:
							break;
						case NX_ALERTOTHER:
							skip=YES;
							break;
					}
				}
			}
#if 0
			switch(*p){
				case '0' : [key0 performClick:nil];	break;
				case '1' : [key1 performClick:nil];	break;
				case '2' : [key2 performClick:nil];	break;
				case '3' : [key3 performClick:nil];	break;
				case '4' : [key4 performClick:nil];	break;
				case '5' : [key5 performClick:nil];	break;
				case '6' : [key6 performClick:nil];	break;
				case '7' : [key7 performClick:nil];	break;
				case '8' : [key8 performClick:nil];	break;
				case '9' : [key9 performClick:nil];	break;
				case 'A' :
				case 'a' : [keyA performClick:nil];	break;
				case 'B' :
				case 'b' : [keyB performClick:nil];	break;
				case 'C' :
				case 'c' : [keyC performClick:nil];	break;
				case 'D' :
				case 'd' : [keyD performClick:nil];	break;
				case 'E' :
				case 'e' : [keyE performClick:nil];	break;
				case 'F' :
				case 'f' : [keyF performClick:nil];	break;
				case '.' : [keyPeriod performClick:nil];break;
				case '+' : [keyPlus performClick:nil];	break;
				case '-' : [keyMinus performClick:nil];	break;
				case '*' : [keyMulti performClick:nil];	break;
				case '/' : [keyDivis performClick:nil];	break;
				case '\n':
				case '=' : [keyEqu performClick:nil];	break;
				case ' ' :
				case '\t': break;
			default  :
				if(skip==NO){
					int	rc;

					rc=NXRunAlertPanel("","Ͱʳʸ(%c)ޤޤƤޤ","ٿͤ(CE)","ʸФ","Ͱʳ٤Ф",*p);
					switch(rc){
						case NX_ALERTDEFAULT:
							[self clearKey:nil];
							free(buff);
							return NO;
							break;
						case NX_ALERTALTERNATE:
							break;
						case NX_ALERTOTHER:
							skip=YES;
							break;
					}
				}
			}
#endif
			p++;
		}
		free(buff);
	}
    return YES;
}

/************************************************************************
 * 	KΥꥢν							*
 ************************************************************************/
- kClear
{
	[kFlag setStringValue:""];
	kmode=NO;
	knum=0;
	kopr=NOP;
	return self;
}

/************************************************************************
 * 	٤Ƥ˥塼ν					*
 ************************************************************************/
- selectAll:sender
{
	[display selectText:self];
	return self;
}

/************************************************************************
 * 	ν							*
 ************************************************************************/
- showInfo:sender
{
	if(!infoPanel){
		[NXApp loadNibSection:"info.nib" owner:self withNames:NO];
	}
	[infoPanel makeKeyAndOrderFront:self];
    return self;
}

/************************************************************************
 * 	إפν							*
 ************************************************************************/
- showHelp:sender
{
	if(!helpPanel){
		[NXApp loadNibSection:"help.nib" owner:self withNames:NO];
	}
	[helpPanel makeKeyAndOrderFront:self];
    return self;
}

/************************************************************************
 * 	ɥΥꥵλľν				*
 ************************************************************************/
- windowDidResize:sender
{
	[display selectText:self];
	return self;
}

@end
