/************************************************************************
 *									*
 *	Dump.app()						*
 *									*
 *	Dump.m								*
 *									*
 * 	Copyright(C)1995,97 Masayuki Kobayashi				*
 *	E-mail:kobamasa@ogata.or.jp					*
 *									*
 ************************************************************************
 *	ver0.50								*
 ************************************************************************/

#import "Dump.h"
#import "DumpFile.h"

@implementation Dump

- appDidInit:sender
{
	static	NXDefaultsVector suspend = {
		{"suspendSize","100"},
		{"suspendMode","YES"},
		{NULL}
	};

	//NXLogError([NXApp appName]);
	NXRegisterDefaults([NXApp appName],suspend);
	[self prefPreset];
	[self setActiveDumpFile:nil];
    return self;
}

- (BOOL)appAcceptsAnotherFile
{
    return YES;
}

- (int)openFile:(char*)fullpath ok:(int *)flag;
{
	if([[DumpFile alloc] initFile:fullpath suspendKSize:[self getKSize]]){
		*flag=YES;
	}else{
		*flag=NO;
	}
    return 0;
}

- open:sender
{
	id	openPanel;

	openPanel=[[OpenPanel new] allowMultipleFiles:YES];
	if([openPanel runModalForTypes:NULL]){
		const char* const	*files;
		char	fullpath[MAXPATHLEN];

		for(files=[openPanel filenames];files && *files;files++){
			id	dumpWindow;

			sprintf(fullpath,"%s/%s",[openPanel directory],*files);
			if(dumpWindow=[self fileCheck:fullpath]){
				[dumpWindow makeKeyAndOrderFront:sender];
			}else{
				[[DumpFile alloc] initFile:fullpath  suspendKSize:[self getKSize]];
			}
		}
	}
    return self;
}

- new:sender
{
	[[DumpFile alloc] init];
   	 return self;
}

- reopen:sender
{
	[activeDumpFile doReOpen:[self getKSize]];
    return self;
}

- close:sender
{
	[activeDumpFile doClose:sender];
    return self;
}

- print:sender
{
	[activeDumpFile doPrint:sender];
    return self;
}
- fileCheck:(char*)path
{
	id	windows=[NXApp windowList];
	id	window;
	int	i=0;

	while(window=[windows objectAt:i++]){
		id	dumpFile=[window delegate];

		if(dumpFile && ([dumpFile class]==[DumpFile class])){
			if(strcmp([dumpFile filename],path)==0){
				return [dumpFile dumpWindow];
			}
		}
	}
	return nil;
}

- setActiveDumpFile:aDumpFile
{
	activeDumpFile=aDumpFile;
	if(activeDumpFile!=nil){
		[reopen setEnabled:YES];
		[close setEnabled:YES];
	}else{
		[reopen setEnabled:NO];
		[close setEnabled:NO];
	}
    return self;
}

- unsetActiveDumpFile:aDumpFile
{
	if(activeDumpFile==aDumpFile){
		[self setActiveDumpFile:nil];
	}
    return self;
}

- (BOOL)searchText:(const char*)text ignoreCase:(BOOL)aCase backwards:(BOOL)aBack wrap:(BOOL)aWarp
{
	return [activeDumpFile searchText:text ignoreCase:aCase backwards:aBack wrap:aWarp];
}

- showInfo:sender
{
	if(!infoPanel){
		[NXApp loadNibSection:"info.nib" owner:self withNames:NO];
	}
	[infoPanel makeKeyAndOrderFront:sender];
	return self;
}

- showHelp:sender
{
	if(!helpPanel){
		[NXApp loadNibSection:"help.nib" owner:self withNames:NO];
	}
	[helpPanel makeKeyAndOrderFront:sender];
	return self;
}

/*
- forward:(SEL)aSelector :(marg_list)argFrame
{
	NXLogError("forward");
	if([activeDumpFile respondsTo:aSelector]){
		return [activeDumpFile performv:aSelector :argFrame];
	}else{
		return [super forward:aSelector :argFrame];
	}
}
*/

- prefSet:sender
{
	if([suspendSwitch tag]==0)	NXWriteDefault([NXApp appName],"suspendMode","YES");
	else				NXWriteDefault([NXApp appName],"suspendMode","NO");
	NXWriteDefault([NXApp appName],"suspendSize",[suspendSize stringValue]);
	return self;
}

- prefPreset
{
	if(strcmp(NXGetDefaultValue([NXApp appName],"suspendMode"),"YES")==0){
		[suspendSwitch selectCellWithTag:0];
	}else{
		[suspendSwitch selectCellWithTag:1];
	}
	[suspendSize setStringValue:NXGetDefaultValue([NXApp appName],"suspendSize")];
	return self;
}

- (int)getKSize
{
	if([suspendSwitch tag]==0){
		return([suspendSize intValue]);
	}else{
		return(0);
	}
}

@end
