/************************************************************************
 *									*
 *	Dump.app()						*
 *									*
 *	DumpFile.m							*
 *									*
 * 	Copyright(C)1995,97 Masayuki Kobayashi				*
 *	E-mail:kobamasa@ogata.or.jp					*
 *									*
 ************************************************************************
 *	ver0.50								*
 ************************************************************************/

#import "Dump.h"
#import "DumpFile.h"
#import "ctype.h"

static void newLocation(NXPoint *p)
{
    static int count=0;

    p->x += (20.0 * count);
    p->y -= (25.0 * count);

    count = (count > 10) ? 0 : count+1;
}

@implementation DumpFile

- init
{
    return [self initFile:NULL suspendKSize:0];
}

- initFile:(char*)path suspendKSize:(int)size
{
	NXRect		theFrame;
	NXStream	*filestream;
	int		rc;
	char		path2[MAXPATHLEN+32];
	char		path3[MAXPATHLEN+32];
	char		*p;

	[super init];
	if(path==NULL){
		filename=NULL;
		Ksize=size;
		[NXApp loadNibSection:"DumpFile.nib" owner:self withNames:NO];
		[dumpWindow getFrame:&theFrame];
		newLocation(&theFrame.origin);
		[dumpWindow moveTo:theFrame.origin.x :theFrame.origin.y];
		[dumpWindow setTitleAsFilename:"̤̾"];
		[dumpWindow makeKeyAndOrderFront:nil];
		return self;
	}
	if(!(filestream=NXMapFile(path,NX_READONLY))){
		NXRunAlertPanel("ץ","ե %s 򥪡ץ󤹤뤳ȤǤޤ",NULL,NULL,NULL,path);
		return nil;
	}
	filename=NXCopyStringBuffer(path);
	Ksize=size;
	[NXApp loadNibSection:"DumpFile.nib" owner:self withNames:NO];
	strcpy(path2,path);
	if((p=strrchr(path2,'/'))==NULL){
		strcpy(path3,":");
		strcat(path3,path2);
	}else{
		*p='\0';
		strcpy(path3,path2);
		strcat(path3,"/:");
		strcat(path3,p+1);
	}
	[dumpWindow getFrame:&theFrame];
	newLocation(&theFrame.origin);
	[dumpWindow moveTo:theFrame.origin.x :theFrame.origin.y];
	[dumpWindow setTitleAsFilename:path3];
	[dumpWindow makeKeyAndOrderFront:nil];
	NXPing();
   	rc=[self dumpping:filestream cancel:YES];
 	if(filestream)	NXCloseMemory(filestream,NX_FREEBUFFER);
  	if(rc==NO){
		[dumpWindow free];
		return nil;
	}
	[dumpWindow setTitleAsFilename:filename];
	return self;
}

-doReOpen:(int)size;
{
	NXStream	*filestream;
	char		path2[MAXPATHLEN+32];
	char		path3[MAXPATHLEN+32];
	char		*p;

	Ksize=size;
	strcpy(path2,filename);
	if((p=strrchr(path2,'/'))==NULL){
		strcpy(path3,":");
		strcat(path3,path2);
	}else{
		*p='\0';
		strcpy(path3,path2);
		strcat(path3,"/:");
		strcat(path3,p+1);
	}
	[dumpWindow setTitleAsFilename:path3];
	[dumpField setText:""];
	NXPing();
	if(!(filestream=NXMapFile(filename,NX_READONLY))){
		NXRunAlertPanel("ƥץ","ե %s 򥪡ץ󤹤뤳ȤǤޤ","",NULL,NULL,filename);
		[dumpWindow free];
		return nil;
	}
   	[self dumpping:filestream cancel:NO];
 	if(filestream)	NXCloseMemory(filestream,NX_FREEBUFFER);
	[dumpWindow setTitleAsFilename:filename];
    return self;
}

- doClose:sender
{
	[dumpWindow performClose:sender];
    return self;
}

/************************************************************************
 *	ɥΡ֥ץܥ򥯥å			*
 *	˥塼Ρ֥פ򥯥åν			*
 ************************************************************************/
- windowWillClose:sender
{
	[dumpWindow setDelegate:nil];	/* delegate ڤΥ?? */
	[self free];			/* DumpFile β */
    return self;			/* ɥ close ƤФ */
}

- free
{
	if(filename)	free(filename);
	[[NXApp delegate] unsetActiveDumpFile:self];
    return [super free];
}

- (const char*)filename
{
	return filename;
}

- dumpWindow
{
	return dumpWindow;
}

- (int)dumpping:(NXStream*)filestream cancel:(int)mode
{
	NXStream	*fp;
	long		address=0;
	unsigned char	buff[16];
	unsigned char	buff2[16+1];
	int		i,size;
	int		sus=NO;

	fp=NXOpenMemory(NULL,0,NX_READWRITE);
	if(fp==NULL){
		NXLogError("NXOpenMemory fail");
		exit(1);
	}
	buff2[16]='\0';
	while((size=NXRead(filestream,buff,sizeof(buff)))==sizeof(buff)){
		unsigned char	*p,*b=buff2;

		NXPrintf(fp,"%08X  ",address);
		for(p=buff,i=0;i<sizeof(buff);i++,p++){
			NXPrintf(fp,"%02X ",*p);
			if(isprint(*p))	*b++=*p;
			else		*b++='.';
		}
		NXPrintf(fp," %s\n",buff2);
		address+=sizeof(buff);
		if(address==Ksize*1024){
			int	rc;
			char	*can=NULL;

			if(mode==YES)	can="ä";
			rc=NXRunAlertPanel("","ե%dKХȰʾΥǤ٤ƥפޤ?\n٤ƥפȤ˻֤ޤ","ޤ","",can,Ksize);
			[dumpWindow makeKeyAndOrderFront:nil];
			NXPing();
			if(rc==NX_ALERTDEFAULT){
				sus=YES;
				break;
			}else if(rc==NX_ALERTOTHER){
				NXCloseMemory(fp,NX_FREEBUFFER);
				return NO;
			}
		}
	}
	NXSeek(filestream,0,NX_FROMSTART);
	if(size>0){
		unsigned char	*p,*b=buff2;

		NXPrintf(fp,"%08X  ",address);
		for(p=buff,i=0;i<size;i++,p++){
			NXPrintf(fp,"%02X ",*p);
			if(isprint(*p))	*b++=*p;
			else		*b++='.';
		}
		*b='\0';
		for(;i<sizeof(buff);i++){
			NXPrintf(fp,"   ");
		}
		NXPrintf(fp," %s\n",buff2);
	}
	if(sus==YES)	NXPrintf(fp,"--- This line is %dKBytes ---\n",Ksize);
	NXSeek(fp,0,NX_FROMSTART);
	[dumpField readText:fp];
	NXCloseMemory(fp,NX_FREEBUFFER);
    return YES;
}

- (BOOL)searchText:(const char*)text ignoreCase:(BOOL)aCase backwards:(BOOL)aBack wrap:(BOOL)aWarp
{
	return [dumpField findText:text ignoreCase:aCase backwards:aBack wrap:aWarp];
}

- windowDidBecomeMain:sender
{
	[[NXApp delegate] setActiveDumpFile:self];
    return self;
}

- doPrint:sender
{
	[dumpField printPSCode:sender];
	return self;
}

- doPaste:sender
{
	[dumpField setText:"paste"];
	return self;
}

@end
